/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.trowels;

import com.matyrobbrt.trowels.Config;
import com.matyrobbrt.trowels.TrowelItem;
import com.matyrobbrt.trowels.TrowelsDatagen;
import com.matyrobbrt.trowels.upgrade.TrowelUpgrade;
import com.matyrobbrt.trowels.upgrade.UpgradeItem;
import java.util.Collection;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="trowels")
public class Trowels {
    public static final String MOD_ID = "trowels";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"trowels");
    public static final RegistryObject<Item> TROWEL = ITEMS.register("trowel", () -> new TrowelItem(new Item.Properties().m_41499_(((Integer)Config.TROWEL_DURABILITY.getDefault()).intValue()).m_41491_(CreativeModeTab.f_40756_).m_41497_(Rarity.UNCOMMON), () -> ((ForgeConfigSpec.IntValue)Config.TROWEL_DURABILITY).get(), () -> ((ForgeConfigSpec.BooleanValue)Config.TROWEL_USES_DURABILITY).get()));
    public static final RegistryObject<Item> REFILL_UPGRADE = ITEMS.register("refill_upgrade", () -> new UpgradeItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_), TrowelUpgrade.REFILL));

    public Trowels() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "trowels-common.toml");
        if (!FMLLoader.isProduction()) {
            modEventBus.register(TrowelsDatagen.class);
        }
        MinecraftForge.EVENT_BUS.addListener(TrowelItem::onDestroySpeed);
        MinecraftForge.EVENT_BUS.addListener(this::handleAnvilUpdate);
    }

    private void handleAnvilUpdate(AnvilUpdateEvent event) {
        TrowelItem trowelItem;
        Item item = event.getLeft().m_41720_();
        if (item instanceof TrowelItem && (trowelItem = (TrowelItem)item).acceptsUpgrades() && (item = event.getRight().m_41720_()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            event.setCost(1);
            Collection<TrowelUpgrade> existingUpgrades = trowelItem.getUpgrades(event.getLeft());
            if (existingUpgrades.contains((Object)upgradeItem.getUpgrade()) || !trowelItem.acceptsUpgrade(event.getLeft(), upgradeItem.getUpgrade())) {
                event.setCanceled(true);
                return;
            }
            ItemStack output = event.getLeft().m_41777_();
            trowelItem.getUpgrades(output).add(upgradeItem.getUpgrade());
            event.setOutput(output);
            event.setCost(1 + existingUpgrades.size() * 3);
        }
    }
}

